# Project Add-Ons

## Search

### Toolbox
* [Fuse.js](https://fusejs.io/)

### Tutorials
* [How to Add Search to a React App with Fuse.js](https://www.freecodecamp.org/news/how-to-add-search-to-a-react-app-with-fuse-js/) (freecodecamp.org)
* [Adding Search with Algolia](https://www.gatsbyjs.com/docs/adding-search-with-algolia) (gatsbyjs.com)
* [Algolia, Firebase, and Next.js — Let's build a search app](https://youtu.be/ZNVAPpTpKpk) (youtube.com)
* [Browser Event Listeners in React for Search and Autocomplete](https://youtu.be/1vOeRDYKb0g) (youtube.com)

### Inspiration
Know of any good examples? Submit a Pull Request!

## Dark Mode

### Toolbox
* [localStorage](https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage) (developer.mozilla.org)

### Tutorials
* [The Quest for the Perfect Dark Mode](https://joshwcomeau.com/gatsby/dark-mode/) (joshwcomeau.com)
* [TailwindCSS Dark Mode in Next.js with Tailwind Typography Prose Classes](https://egghead.io/blog/tailwindcss-dark-mode-nextjs-typography-prose) (egghead.io)
* [Dark mode in React: An in-depth guide](https://blog.logrocket.com/dark-mode-in-react-an-in-depth-guide/) (logrocket.com)
* [How to Create a Theme-able Static Website](https://www.freecodecamp.org/news/design-a-themeable-static-website/) (freecodecamp.org)

### Inspiration
* [Josh W. Comeau](https://joshwcomeau.com/) (joshwcomeau.com)

## Webmentions

### Toolbox
* [Webmention.io](https://webmention.io/) (webmention.io)
* [Bridgy](https://brid.gy/) (brid.gy)
* [Gatsby Plugin Webmention](https://github.com/ChristopherBiscardi/gatsby-plugin-webmention) (github.com)

### Tutorials
* [Indieweb pt2: Using Webmentions in Eleventy](https://mxb.dev/blog/using-webmentions-on-static-sites/) (mxb.dev)
* [Clientside Webmentions](https://www.swyx.io/writing/clientside-webmentions/) (swyx.io)
* [Getting started with Webmentions in Gatsby](https://www.knutmelvaer.no/blog/2019/06/getting-started-with-webmentions-in-gatsby/) (knutmelvaer.no)
* [Building Gatsby Plugin Webmentions](https://www.christopherbiscardi.com/post/building-gatsby-plugin-webmentions) (christopherbiscardi.com)

### Inspiration
* [Knut Melvær](https://www.knutmelvaer.no/blog/) (knutmelvaer.no)
* [Swyx](https://swyx.io) (swyx.io)

## Analytics

### Toolbox
* [Google Analytics](https://marketingplatform.google.com/about/analytics/) (marketingplatform.google.com)
* [Custom Dimensions (GA)](https://support.google.com/analytics/answer/2709828?hl=en) (support.google.com)
* [Filters (GA)](https://support.google.com/analytics/answer/1033162?hl=en) (support.google.com)

### Tutorials
* [How to Make Sense of Google Analytics and the Traffic to Your Website](https://www.colbyfayock.com/2019/09/making-sense-of-google-analytics-and-the-traffic-to-your-website) (colbyfayock.com
* [The 8 Most Important Google Analytics Filters](https://www.lovesdata.com/blog/google-analytics-filters) (lovesdata.com)

## Code Stats

### Toolbox
* [Github REST API](https://docs.github.com/en/rest) (docs.github.com)
* [Github GraphQL API](https://docs.github.com/en/graphql) (docs.github.com)
* [Postman](https://www.postman.com/) (postman.com)

### Tutorials
* [Github API - retrieve user commits?](https://stackoverflow.com/questions/21869795/github-api-retrieve-user-commits) (stackoverflow.com)
* [How to Test and Play with Web APIs the Easy Way with Postman](https://www.freecodecamp.org/news/how-to-test-and-play-with-web-apis-the-easy-way-with-postman/) (freecodecamp.org)

### Inspiration
Know of any good examples? Submit a Pull Request!

## Highlight & Share

### Toolbox
* [Window.getSelection](https://developer.mozilla.org/en-US/docs/Web/API/Window/getSelection) (developer.mozilla.org)
* [Cloudinary](https://cloudinary.com/) (cloudinary.com)

### Tutorials
* [Tweetable Selections](https://www.christopherbiscardi.com/tweetable-selections) (christopherbiscardi.com)

### Inspiration
* [Chris Biscardi](https://www.christopherbiscardi.com) (christopherbiscardi.com)
* [react-highlight-pop](https://github.com/codeshifu/react-highlight-pop) (github.com)

---

## Know of any other good resources?
If you know of a great tutorial or another tool that can help others, open a pull request with a link!
